#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "Gravitational Segregation of an Asphaltenic Oil"
show title

$Expt << END
#           Depth                            Pressure (bar)     Sat Pres (bar)           MW            Density (kg/m3)       Viscosity (cp)          C1 z (%)          C1 zwt (%)            Asphalt z (%)             Asphalt zwt (%)
#  Stg       (m)        Feed       Zone       Expt    Calc       Expt    Calc       Expt    Calc        Expt    Calc         Expt      Calc        Expt    Calc       Expt    Calc         Expt        Calc           Expt        Calc
#------   ---------   -------   ---------   ----------------   ----------------   ----------------   ------------------   --------------------   ----------------   ----------------   ------------------------   ------------------------
     1     1600.00       NaN       Gas          NaN  353.76        NaN  340.89        NaN   23.29         NaN   238.8           NaN   0.03005        NaN  82.865        NaN  57.081            NaN  1.7811e-08            NaN  7.6474e-07
     2     1700.00       NaN       Gas          NaN  356.12        NaN  348.73        NaN   23.60         NaN   243.3           NaN   0.03056        NaN  82.527        NaN  56.099            NaN  2.9205e-08            NaN  1.2375e-06
     3     1800.00     F1800       Gas          NaN  358.53        NaN  357.00        NaN   23.95         NaN   248.3           NaN   0.03114        NaN  82.157        NaN  55.034            NaN  4.9039e-08            NaN  2.0476e-06
   NaN     1825.00       NaN     Gas-Oil        NaN  359.14        NaN  359.14        NaN   24.04         NaN   249.7           NaN   0.03129        NaN  82.059        NaN  54.752            NaN  5.6065e-08            NaN  2.3317e-06
   NaN     1825.00       NaN     Oil-Gas        NaN  359.14        NaN  359.14        NaN   78.22         NaN   617.6           NaN   0.26226        NaN  56.634        NaN  11.616            NaN  2.2732e-01            NaN  2.9064e+00
     4     1850.00       NaN       Oil          NaN  360.66        NaN  357.25        NaN   79.32         NaN   622.0           NaN   0.27405        NaN  56.342        NaN  11.396            NaN  2.5013e-01            NaN  3.1535e+00
     5     1900.00       NaN       Oil          NaN  363.73        NaN  353.66        NaN   81.55         NaN   630.6           NaN   0.29936        NaN  55.767        NaN  10.970            NaN  3.0134e-01            NaN  3.6950e+00
     6     1925.00       NaN       Oil          NaN  365.28        NaN  351.95        NaN   82.69         NaN   634.8           NaN   0.31301        NaN  55.481        NaN  10.764            NaN  3.3008e-01            NaN  3.9915e+00
   NaN     1948.50       NaN       Oil          NaN  366.75        NaN  350.39        NaN   83.78         NaN   638.9           NaN   0.32650        NaN  55.214        NaN  10.573            NaN  3.5921e-01            NaN  4.2874e+00
   NaN     1948.50       NaN       Oil          NaN  366.75        NaN  350.40        NaN   83.78         NaN   638.9           NaN   0.32651        NaN  55.214        NaN  10.573            NaN  3.5922e-01            NaN  4.2875e+00
     7     1950.00       NaN       Oil          NaN  366.85        NaN  350.76        NaN   83.85         NaN   639.1           NaN   0.32739        NaN  55.197        NaN  10.561            NaN  3.6114e-01            NaN  4.3069e+00
     8     1975.00       NaN       Oil          NaN  368.42        NaN  357.16        NaN   85.03         NaN   643.4           NaN   0.34259        NaN  54.914        NaN  10.361            NaN  3.9475e-01            NaN  4.6426e+00
     9     2000.00     F2000       Oil       370.00  370.00        NaN  363.99        NaN   86.23         NaN   647.7           NaN   0.35868        NaN  54.630     10.200  10.164            NaN  4.3115e-01     5.0000e+00  5.0000e+00
    10     2025.00       NaN       Oil          NaN  371.59        NaN  371.30        NaN   87.46         NaN   652.0           NaN   0.37576        NaN  54.346        NaN   9.969            NaN  4.7061e-01            NaN  5.3809e+00
   NaN     2026.23       NaN     Oil-Tar        NaN  371.67        NaN  371.67        NaN   87.52         NaN   652.2           NaN   0.37663        NaN  54.332        NaN   9.960            NaN  4.7264e-01            NaN  5.4004e+00
   NaN     2026.23       NaN     Tar-Oil        NaN  371.67        NaN  371.67        NaN  323.25         NaN  1001.7           NaN  21.08652        NaN  33.826        NaN   1.679            NaN  2.5659e+01            NaN  7.9378e+01
    11     2050.00       NaN       Tar          NaN  374.01        NaN  362.65        NaN  326.41         NaN  1003.7           NaN  21.59151        NaN  33.664        NaN   1.655            NaN  2.6021e+01            NaN  7.9721e+01
    12     2075.00       NaN       Tar          NaN  376.47        NaN  353.65        NaN  329.66         NaN  1005.6           NaN  22.11487        NaN  33.498        NaN   1.630            NaN  2.6395e+01            NaN  8.0067e+01
    13     2100.00       NaN       Tar          NaN  378.94        NaN  350.33        NaN  332.84         NaN  1007.5           NaN  22.63064        NaN  33.336        NaN   1.607            NaN  2.6760e+01            NaN  8.0398e+01
    14     2125.00       NaN       Tar          NaN  381.41        NaN  348.46        NaN  335.96         NaN  1009.3           NaN  23.13922        NaN  33.178        NaN   1.584            NaN  2.7117e+01            NaN  8.0716e+01
    15     2150.00       NaN       Tar          NaN  383.89        NaN  346.60        NaN  339.02         NaN  1011.1           NaN  23.64098        NaN  33.024        NaN   1.563            NaN  2.7468e+01            NaN  8.1022e+01
    16     2200.00     F2200       Tar          NaN  388.85        NaN  342.95        NaN  344.97         NaN  1014.4           NaN  24.62533        NaN  32.724        NaN   1.522            NaN  2.8150e+01            NaN  8.1600e+01
    17     2300.00       NaN       Tar          NaN  398.83        NaN  335.87        NaN  356.30         NaN  1020.5           NaN  26.52461        NaN  32.159        NaN   1.448            NaN  2.9445e+01            NaN  8.2642e+01
    18     2400.00       NaN       Tar          NaN  408.87        NaN  329.07        NaN  366.97         NaN  1025.9           NaN  28.34216        NaN  31.631        NaN   1.383            NaN  3.0664e+01            NaN  8.3560e+01
END
set xlabel "Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 5:2 with points title "Expt", $Expt using 6:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Saturation Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_SATP_1.pdf"
plot [*:*][*:*] $Expt using 7:2 with points title "Expt", $Expt using 8:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Molecular Weight"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 9:2 with points title "Expt", $Expt using 10:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Density (kg/m3)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_DEN_1.pdf"
plot [*:*][*:*] $Expt using 11:2 with points title "Expt", $Expt using 12:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Viscosity (cp)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_VIS_1.pdf"
plot [*:*][*:*] $Expt using 13:2 with points title "Expt", $Expt using 14:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Overall C1 Mole Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_Z-C1_1.pdf"
plot [*:*][*:*] $Expt using 15:2 with points title "Expt", $Expt using 16:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C1 Mass Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_ZWT-C1_1.pdf"
plot [*:*][*:*] $Expt using 17:2 with points title "Expt", $Expt using 18:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Asphalt Mole Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_Z-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 19:2 with points title "Expt", $Expt using 20:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Overall Asphalt Mass Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_001_DEPTH_vs_ZWT-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 21:2 with points title "Expt", $Expt using 22:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x

set title "Saturated Properties of a Segregated Asphaltenic Oil"
show title

$Expt << END
#           Depth                  Sat Pres (bar)     Pressure (bar)       Liq Sat (%)          Liq MW             Gas MW               MW            Liq Den (kg/m3)      Gas Den (kg/m3)      Density (kg/m3)       Liq Vis (cp)         Gas Vis (cp)         Viscosity (cp)          C1 x (%)           C1 y (%)           C1 z (%)          C1 xwt (%)         C1 ywt (%)         C1 zwt (%)         Asphalt x (%)           Asphalt y (%)              Asphalt z (%)          Asphalt xwt (%)         Asphalt ywt (%)            Asphalt zwt (%)
#  Stg       (m)         Zone       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt    Calc         Expt    Calc         Expt    Calc         Expt     Calc        Expt     Calc        Expt      Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc         Expt        Calc           Expt        Calc          Expt    Calc          Expt        Calc           Expt        Calc
#------   ---------   ---------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------   ------------------   ------------------   ------------------   ------------------   --------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------   ------------------------   ------------------------   ------------------   ------------------------   ------------------------
     1     1600.00       Gas          NaN  340.89        NaN  353.76        NaN    0.00        NaN   87.45        NaN  23.290        NaN   23.29         NaN   644.9          NaN  233.02          NaN   233.0          NaN   0.3463         NaN  0.02932          NaN   0.02932        NaN  54.208        NaN  82.865        NaN  82.865        NaN   9.944        NaN  57.081        NaN  57.081         NaN   0.4193            NaN  1.7811e-08            NaN  1.7811e-08         NaN   4.794             NaN  7.6474e-07            NaN  7.6474e-07
     2     1700.00       Gas          NaN  348.73        NaN  356.12        NaN    0.00        NaN   83.27        NaN  23.601        NaN   23.60         NaN   632.9          NaN  240.05          NaN   240.1          NaN   0.3058         NaN  0.03014          NaN   0.03014        NaN  55.272        NaN  82.527        NaN  82.527        NaN  10.649        NaN  56.099        NaN  56.099         NaN   0.3232            NaN  2.9205e-08            NaN  2.9205e-08         NaN   3.881             NaN  1.2375e-06            NaN  1.2375e-06
     3     1800.00       Gas          NaN  357.00        NaN  358.53        NaN    0.00        NaN   79.21        NaN  23.950        NaN   23.95         NaN   620.7          NaN  247.66          NaN   247.7          NaN   0.2704         NaN  0.03105          NaN   0.03105        NaN  56.358        NaN  82.157        NaN  82.157        NaN  11.414        NaN  55.034        NaN  55.034         NaN   0.2446            NaN  4.9039e-08            NaN  4.9039e-08         NaN   3.088             NaN  2.0476e-06            NaN  2.0476e-06
   NaN     1825.00     Gas-Oil        NaN  359.14        NaN  359.14        NaN    0.00        NaN   78.22        NaN  24.044        NaN   24.04         NaN   617.6          NaN  249.66          NaN   249.7          NaN   0.2623         NaN  0.03129          NaN   0.03129        NaN  56.634        NaN  82.059        NaN  82.059        NaN  11.616        NaN  54.752        NaN  54.752         NaN   0.2273            NaN  5.6065e-08            NaN  5.6065e-08         NaN   2.906             NaN  2.3317e-06            NaN  2.3317e-06
   NaN     1825.00     Oil-Gas        NaN  359.14        NaN  359.14        NaN  100.00        NaN   78.22        NaN  24.044        NaN   78.22         NaN   617.6          NaN  249.66          NaN   617.6          NaN   0.2623         NaN  0.03129          NaN   0.26226        NaN  56.634        NaN  82.059        NaN  56.634        NaN  11.616        NaN  54.752        NaN  11.616         NaN   0.2273            NaN  5.6065e-08            NaN  2.2732e-01         NaN   2.906             NaN  2.3317e-06            NaN  2.9064e+00
     4     1850.00       Oil          NaN  357.25        NaN  360.66        NaN  100.00        NaN   79.32        NaN  23.955        NaN   79.32         NaN   621.2          NaN  247.83          NaN   621.2          NaN   0.2717         NaN  0.03107          NaN   0.27170        NaN  56.342        NaN  82.150        NaN  56.342        NaN  11.396        NaN  55.017        NaN  11.396         NaN   0.2501            NaN  5.0281e-08            NaN  2.5013e-01         NaN   3.153             NaN  2.0990e-06            NaN  3.1535e+00
     5     1900.00       Oil          NaN  353.66        NaN  363.73        NaN  100.00        NaN   81.55        NaN  23.789        NaN   81.55         NaN   628.3          NaN  244.37          NaN   628.3          NaN   0.2918         NaN  0.03065          NaN   0.29184        NaN  55.767        NaN  82.321        NaN  55.767        NaN  10.970        NaN  55.517        NaN  10.970         NaN   0.3013            NaN  4.0881e-08            NaN  3.0134e-01         NaN   3.695             NaN  1.7185e-06            NaN  3.6950e+00
     6     1925.00       Oil          NaN  351.95        NaN  365.28        NaN  100.00        NaN   82.69        NaN  23.711        NaN   82.69         NaN   631.9          NaN  242.73          NaN   631.9          NaN   0.3026         NaN  0.03046          NaN   0.30263        NaN  55.481        NaN  82.401        NaN  55.481        NaN  10.764        NaN  55.753        NaN  10.764         NaN   0.3301            NaN  3.7049e-08            NaN  3.3008e-01         NaN   3.992             NaN  1.5625e-06            NaN  3.9915e+00
   NaN     1948.50       Oil          NaN  350.39        NaN  366.75        NaN  100.00        NaN   83.78        NaN  23.641        NaN   83.78         NaN   635.3          NaN  241.26          NaN   635.3          NaN   0.3133         NaN  0.03029          NaN   0.31329        NaN  55.214        NaN  82.474        NaN  55.214        NaN  10.573        NaN  55.967        NaN  10.573         NaN   0.3592            NaN  3.3875e-08            NaN  3.5921e-01         NaN   4.287             NaN  1.4328e-06            NaN  4.2874e+00
   NaN     1948.50       Oil          NaN  350.40        NaN  366.75        NaN    0.00        NaN  330.15        NaN  83.782        NaN   83.78         NaN  1004.3          NaN  635.32          NaN   635.3          NaN  21.6585         NaN  0.31329          NaN   0.31329        NaN  33.409        NaN  55.214        NaN  55.214        NaN   1.623        NaN  10.573        NaN  10.573         NaN  26.4432            NaN  3.5922e-01            NaN  3.5922e-01         NaN  80.096             NaN  4.2875e+00            NaN  4.2875e+00
     7     1950.00       Oil          NaN  350.76        NaN  366.85        NaN    0.00        NaN  330.02        NaN  83.851        NaN   83.85         NaN  1004.3          NaN  635.64          NaN   635.6          NaN  21.6482         NaN  0.31436          NaN   0.31436        NaN  33.417        NaN  55.197        NaN  55.197        NaN   1.624        NaN  10.561        NaN  10.561         NaN  26.4292            NaN  3.6114e-01            NaN  3.6114e-01         NaN  80.083             NaN  4.3069e+00            NaN  4.3069e+00
     8     1975.00       Oil          NaN  357.16        NaN  368.42        NaN    0.00        NaN  327.91        NaN  85.029        NaN   85.03         NaN  1003.5          NaN  641.02          NaN   641.0          NaN  21.4727         NaN  0.33306          NaN   0.33306        NaN  33.545        NaN  54.914        NaN  54.914        NaN   1.641        NaN  10.361        NaN  10.361         NaN  26.1890            NaN  3.9475e-01            NaN  3.9475e-01         NaN  79.867             NaN  4.6426e+00            NaN  4.6426e+00
     9     2000.00       Oil          NaN  363.99     370.00  370.00        NaN    0.00        NaN  325.69        NaN  86.230        NaN   86.23         NaN  1002.7          NaN  646.45          NaN   646.5          NaN  21.2889         NaN  0.35336          NaN   0.35336        NaN  33.679        NaN  54.630        NaN  54.630        NaN   1.659        NaN  10.164     10.200  10.164         NaN  25.9368            NaN  4.3115e-01            NaN  4.3115e-01         NaN  79.636             NaN  5.0000e+00     5.0000e+00  5.0000e+00
    10     2025.00       Oil          NaN  371.30        NaN  371.59        NaN    0.00        NaN  323.36        NaN  87.458        NaN   87.46         NaN  1001.8          NaN  651.96          NaN   652.0          NaN  21.0963         NaN  0.37549          NaN   0.37549        NaN  33.819        NaN  54.346        NaN  54.346        NaN   1.678        NaN   9.969        NaN   9.969         NaN  25.6720            NaN  4.7061e-01            NaN  4.7061e-01         NaN  79.391             NaN  5.3809e+00            NaN  5.3809e+00
   NaN     2026.23     Oil-Tar        NaN  371.67        NaN  371.67        NaN    0.00        NaN  323.25        NaN  87.519        NaN   87.52         NaN  1001.7          NaN  652.23          NaN   652.2          NaN  21.0865         NaN  0.37663          NaN   0.37663        NaN  33.826        NaN  54.332        NaN  54.332        NaN   1.679        NaN   9.960        NaN   9.960         NaN  25.6586            NaN  4.7264e-01            NaN  4.7264e-01         NaN  79.378             NaN  5.4004e+00            NaN  5.4004e+00
   NaN     2026.23     Tar-Oil        NaN  371.67        NaN  371.67        NaN  100.00        NaN  323.25        NaN  87.519        NaN  323.25         NaN  1001.7          NaN  652.23          NaN  1001.7          NaN  21.0865         NaN  0.37663          NaN  21.08652        NaN  33.826        NaN  54.332        NaN  33.826        NaN   1.679        NaN   9.960        NaN   1.679         NaN  25.6586            NaN  4.7264e-01            NaN  2.5659e+01         NaN  79.378             NaN  5.4004e+00            NaN  7.9378e+01
    11     2050.00       Tar          NaN  362.65        NaN  374.01        NaN  100.00        NaN  326.41        NaN  85.847        NaN  326.41         NaN  1003.0          NaN  644.91          NaN  1003.0          NaN  21.3759         NaN  0.34763          NaN  21.37590        NaN  33.664        NaN  54.748        NaN  33.664        NaN   1.655        NaN  10.231        NaN   1.655         NaN  26.0214            NaN  4.1987e-01            NaN  2.6021e+01         NaN  79.721             NaN  4.8909e+00            NaN  7.9721e+01
    12     2075.00       Tar          NaN  353.65        NaN  376.47        NaN  100.00        NaN  329.66        NaN  84.051        NaN  329.66         NaN  1004.3          NaN  636.96          NaN  1004.3          NaN  21.6757         NaN  0.31915          NaN  21.67571        NaN  33.498        NaN  55.207        NaN  33.498        NaN   1.630        NaN  10.537        NaN   1.630         NaN  26.3946            NaN  3.6788e-01            NaN  2.6395e+01         NaN  80.067             NaN  4.3768e+00            NaN  8.0067e+01
    13     2100.00       Tar          NaN  350.33        NaN  378.94        NaN  100.00        NaN  332.84        NaN  23.565        NaN  332.84         NaN  1005.9          NaN  240.36          NaN  1005.9          NaN  22.0740         NaN  0.03019          NaN  22.07396        NaN  33.336        NaN  82.555        NaN  33.336        NaN   1.607        NaN  56.202        NaN   1.607         NaN  26.7598            NaN  3.1542e-08            NaN  2.6760e+01         NaN  80.398             NaN  1.3385e-06            NaN  8.0398e+01
    14     2125.00       Tar          NaN  348.46        NaN  381.41        NaN  100.00        NaN  335.96        NaN  23.445        NaN  335.96         NaN  1007.5          NaN  238.17          NaN  1007.5          NaN  22.4915         NaN  0.02993          NaN  22.49147        NaN  33.178        NaN  82.682        NaN  33.178        NaN   1.584        NaN  56.578        NaN   1.584         NaN  27.1174            NaN  2.6707e-08            NaN  2.7117e+01         NaN  80.716             NaN  1.1391e-06            NaN  8.0716e+01
    15     2150.00       Tar          NaN  346.60        NaN  383.89        NaN  100.00        NaN  339.02        NaN  23.331        NaN  339.02         NaN  1009.0          NaN  236.05          NaN  1009.0          NaN  22.9010         NaN  0.02969          NaN  22.90102        NaN  33.024        NaN  82.804        NaN  33.024        NaN   1.563        NaN  56.940        NaN   1.563         NaN  27.4680            NaN  2.2713e-08            NaN  2.7468e+01         NaN  81.022             NaN  9.7354e-07            NaN  8.1022e+01
    16     2200.00       Tar          NaN  342.95        NaN  388.85        NaN  100.00        NaN  344.97        NaN  23.117        NaN  344.97         NaN  1011.9          NaN  232.00          NaN  1011.9          NaN  23.6978         NaN  0.02923          NaN  23.69784        NaN  32.724        NaN  83.036        NaN  32.724        NaN   1.522        NaN  57.626        NaN   1.522         NaN  28.1497            NaN  1.6626e-08            NaN  2.8150e+01         NaN  81.600             NaN  7.1919e-07            NaN  8.1600e+01
    17     2300.00       Tar          NaN  335.87        NaN  398.83        NaN  100.00        NaN  356.30        NaN  22.742        NaN  356.30         NaN  1017.2          NaN  224.57          NaN  1017.2          NaN  25.2116         NaN  0.02840          NaN  25.21160        NaN  32.159        NaN  83.452        NaN  32.159        NaN   1.448        NaN  58.870        NaN   1.448         NaN  29.4452            NaN  9.2791e-09            NaN  2.9445e+01         NaN  82.642             NaN  4.0802e-07            NaN  8.2642e+01
    18     2400.00       Tar          NaN  329.07        NaN  408.87        NaN  100.00        NaN  366.97        NaN  22.421        NaN  366.97         NaN  1021.8          NaN  217.86          NaN  1021.8          NaN  26.6328         NaN  0.02767          NaN  26.63280        NaN  31.631        NaN  83.819        NaN  31.631        NaN   1.383        NaN  59.975        NaN   1.383         NaN  30.6641            NaN  5.4143e-09            NaN  3.0664e+01         NaN  83.560             NaN  2.4148e-07            NaN  8.3560e+01
END
set xlabel "Saturation Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_SATP_1.pdf"
plot [*:*][*:*] $Expt using 4:2 with points title "Expt", $Expt using 5:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 6:2 with points title "Expt", $Expt using 7:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Liquid Saturation (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_LS_1.pdf"
plot [*:*][*:*] $Expt using 8:2 with points title "Expt", $Expt using 9:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Liquid Phase Molecular Weight"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_LMW_1.pdf"
plot [*:*][*:*] $Expt using 10:2 with points title "Expt", $Expt using 11:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Gas Phase Molecular Weight"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_GMW_1.pdf"
plot [*:*][*:*] $Expt using 12:2 with points title "Expt", $Expt using 13:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Molecular Weight"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 14:2 with points title "Expt", $Expt using 15:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Liquid Phase Density (kg/m3)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_LDEN_1.pdf"
plot [*:*][*:*] $Expt using 16:2 with points title "Expt", $Expt using 17:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Gas Phase Density (kg/m3)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_GDEN_1.pdf"
plot [*:*][*:*] $Expt using 18:2 with points title "Expt", $Expt using 19:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Density (kg/m3)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_DEN_1.pdf"
plot [*:*][*:*] $Expt using 20:2 with points title "Expt", $Expt using 21:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Liquid Phase Viscosity (cp)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_LVIS_1.pdf"
plot [*:*][*:*] $Expt using 22:2 with points title "Expt", $Expt using 23:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Gas Phase Viscosity (cp)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_GVIS_1.pdf"
plot [*:*][*:*] $Expt using 24:2 with points title "Expt", $Expt using 25:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Viscosity (cp)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_VIS_1.pdf"
plot [*:*][*:*] $Expt using 26:2 with points title "Expt", $Expt using 27:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Liquid C1 Mole Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_X-C1_1.pdf"
plot [*:*][*:*] $Expt using 28:2 with points title "Expt", $Expt using 29:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Gas C1 Mole Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_Y-C1_1.pdf"
plot [*:*][*:*] $Expt using 30:2 with points title "Expt", $Expt using 31:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C1 Mole Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_Z-C1_1.pdf"
plot [*:*][*:*] $Expt using 32:2 with points title "Expt", $Expt using 33:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Liquid C1 Mass Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_XWT-C1_1.pdf"
plot [*:*][*:*] $Expt using 34:2 with points title "Expt", $Expt using 35:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Gas C1 Mass Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_YWT-C1_1.pdf"
plot [*:*][*:*] $Expt using 36:2 with points title "Expt", $Expt using 37:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C1 Mass Fraction (%)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_ZWT-C1_1.pdf"
plot [*:*][*:*] $Expt using 38:2 with points title "Expt", $Expt using 39:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Liquid Asphalt Mole Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_X-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 40:2 with points title "Expt", $Expt using 41:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Gas Asphalt Mole Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_Y-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 42:2 with points title "Expt", $Expt using 43:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Overall Asphalt Mole Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_Z-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 44:2 with points title "Expt", $Expt using 45:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Liquid Asphalt Mass Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_XWT-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 46:2 with points title "Expt", $Expt using 47:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Gas Asphalt Mass Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_YWT-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 48:2 with points title "Expt", $Expt using 49:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x
set xlabel "Overall Asphalt Mass Fraction (%)"
set logscale x
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_002_DEPTH_vs_ZWT-Asphalt_1.pdf"
plot [*:*][*:*] $Expt using 50:2 with points title "Expt", $Expt using 51:2 with lines title "Calc"
set yrange [] noreverse
unset logscale x

set output
